#!/usr/bin/perl -T

use strict;
use warnings;
use 5.010;
use utf8;

sub GetAddToReplyCartButton { # itemHash
	my $itemHash = shift;

	if (!IsItem($itemHash)) {
		WriteLog('GetAddToReplyCartButton: warning: IsItem($itemHash) is FALSE; caller = ' . join(',', caller));
		return '';
	}

	#todo sanity

	my $button = '
		<nobr><a class=replyCartButton href=#>+cart</a></nobr>
	';
	$button = trim($button);

	$button = AddAttributeToTag(
		$button, 'a', 'item-id',
		$itemHash
	);

	$button = AddAttributeToTag(
		$button, 'a', 'onclick',
		"if (window.addToReplyCartButton) { return addToReplyCartButton('$itemHash', this); }"
	);
	return $button;
} # GetAddToReplyCartButton()

1;
